*****************************************
*** TAXES AND CONTRIBUTIONS ON LABOUR ***
*****************************************
cd "Z:\work\Baze\SILC_Serbia\2019"

use data1_hh, replace 
merge 1:1 idhh using msa_sim
drop _merge
merge 1:1 idhh using msa_sim_ref
drop _merge

* compare 
sum msa_sim msa_sim_ref

* replace old wages with new wages
gen dispy_r = dispy - msa_sim + msa_sim_ref

sum dispy_r dispy

merge 1:m idhh using weight_ind

* caclulate income per adult equivalent
gen income_ae = dispy/adulteq
gen income_ae_r = dispy_r/adulteq

* calculate poverty line
sum income_ae [aw=weight] , d
gen povline =r(p50)*0.60
sum povline

* poverty indicator
gen pov60 = income_ae<povline
gen pov60_r = income_ae_r<povline

* poverty rate
ta pov60 [iw=weight]
ta pov60_r [iw=weight]

* inequality
* ssc install ineqdec0 // if you need to instal it
ineqdec0 income_ae  [aw=weight]
ineqdec0 income_ae_r  [aw=weight]
